<?php

require_once('gc_abstract_controller.class.php');

/**
 * @controller GcSelectWebsiteController
 *
 * Handle the selection of a website
 */

if (!class_exists('GcSelectWebsiteController')) {
    class GcSelectWebsiteController extends GcController {

        public function __construct($post) {
            parent::__construct($post);
        }

        public function handleOptionForm() {
            GcLogger::getLogger()->debug('GcSelectWebsiteController::handleOptionForm()');

            // The user has some websites but didn't choose one
            if (
                !GcParamsService::getInstance()->graphcommentIsWebsiteChoosen()
                && isset($this->post['gc-create-website'])
                && $this->post['gc-create-website'] === 'true'
            ) {
                GcLogger::getLogger()->debug('GcSelectWebsiteController::handleOptionForm() - User wants to create a new website');

                update_option('gc_create_website', 'true');
                wp_redirect(admin_url('admin.php?page=graphcomment&debug=chooseWebsite'));
                exit;
            }

            if (isset($this->post['gc_website_id'])) {
                $gc_website_id = sanitize_text_field($this->post['gc_website_id']);
                $ret = GcParamsService::getInstance()->graphcommentSetWebsite($gc_website_id);

                if ($ret !== true) {
                    GcLogger::getLogger()->error('GcSelectWebsiteController::handleOptionForm() - Set website error, ret: ' . $ret);

                    update_option('gc-msg', json_encode(array(
                        'type' => 'danger',
                        'content' => esc_html($ret)
                    )));
                } else {
                    GcLogger::getLogger()->debug('GcSelectWebsiteController::handleOptionForm() - Set website success: ' . $gc_website_id);

                    update_option('gc-msg', json_encode(array(
                        'type' => 'success',
                        'content' => sprintf(
                            __('GraphComment Website Selected: %s', 'graphcomment-comment-system'),
                            '<i>' . esc_html($gc_website_id) . '</i>'
                        ),
                        'active_tab' => 'general'
                    )));
                }

                wp_redirect(admin_url('admin.php?page=graphcomment-settings'));
                exit;
            }
        }
    }
}
