<?php

require_once('gc_abstract_controller.class.php');

/**
 * @controller GcSynchronisationController
 *
 * Gère l'onglet de synchronisation.
 * Configure un cron WordPress pour synchroniser les commentaires GraphComment avec la base de données WordPress.
 */

if ( ! class_exists( 'GcSynchronisationController' ) ) {
    class GcSynchronisationController extends GcController {

        public function handleOptionForm() {
            GcLogger::getLogger()->debug( 'GcSynchronisationController::handleOptionForm()' );

            if ( ! isset( $this->post['gc_sync_comments'] ) ) {
                GcLogger::getLogger()->error( 'GcSynchronisationController::handleOptionForm() - Paramètre gc_sync_comments non envoyé, redirection vers la page des paramètres' );

                // Paramètre non envoyé, rien à faire
                wp_redirect( admin_url( 'admin.php?page=graphcomment-settings' ) );
                exit;
            }

            if ( isset( $this->post['gc_sync_interval'] ) ) {
                $gc_sync_interval = sanitize_text_field( $this->post['gc_sync_interval'] );
                update_option( 'gc_sync_interval', $gc_sync_interval );
            }

            // L'utilisateur a désactivé la synchronisation, mise à jour de l'option
            if ( $this->post['gc_sync_comments'] === 'false' ) {
                GcLogger::getLogger()->debug( 'GcSynchronisationController::handleOptionForm() - Action : Désactiver la synchronisation' );

                // Désactiver la synchronisation
                update_option( 'gc_sync_comments', 'false' );
                delete_option( 'gc_sync_last_success' );
                delete_option( 'gc-sync-error' );
                wp_clear_scheduled_hook( 'graphcomment_cron_task_sync_comments_action' );

                // Afficher le message
                update_option( 'gc-msg', json_encode( array(
                    'type'       => 'warning',
                    'content'    => __( 'Sync Deactivated', 'graphcomment-comment-system' ),
                    'active_tab' => 'synchronization'
                ) ) );

                wp_redirect( admin_url( 'admin.php?page=graphcomment-settings' ) );
                exit;
            }

            if ( $this->post['gc_sync_comments'] !== 'true' ) {
                GcLogger::getLogger()->debug( 'GcSynchronisationController::handleOptionForm() - Paramètre gc_sync_comments différent de "true", redirection vers la page des paramètres' );

                wp_redirect( admin_url( 'admin.php?page=graphcomment-settings' ) );
                exit;
            }

            $gc_public_key = GcParamsService::getInstance()->graphcommentGetWebsite();
            if ( is_null( $gc_public_key ) ) {
                GcLogger::getLogger()->error( 'GcSynchronisationController::handleOptionForm() - Clé publique manquante' );

                // L'utilisateur n'a pas encore défini la clé publique
                update_option( 'gc_sync_comments', 'false' );
                delete_option( 'gc-sync-error' );
                wp_clear_scheduled_hook( 'graphcomment_cron_task_sync_comments_action' );
                update_option( 'gc-msg', json_encode( array(
                    'type'       => 'danger',
                    'content'    => __( 'No Public Key', 'graphcomment-comment-system' ),
                    'active_tab' => 'synchronization'
                ) ) );

                wp_redirect( admin_url( 'admin.php?page=graphcomment-settings' ) );
                exit;
            }

            GcLogger::getLogger()->debug( 'GcSynchronisationController::handleOptionForm() - Tout est correct' );

            // Tout est bon, on peut enregistrer l'option
            update_option( 'gc_sync_comments', 'true' );
            delete_option( 'gc-sync-error' );

            GcParamsService::getInstance()->fetchApiKeys();

            // Initialiser la tâche CRON pour synchroniser les commentaires
            $gc_sync_interval = get_option( 'gc_sync_interval' );
            GcLogger::getLogger()->debug( 'GcSynchronisationController::handleOptionForm() - Initialisation du cron de synchronisation : ' . $gc_sync_interval );
            wp_clear_scheduled_hook( 'graphcomment_cron_task_sync_comments_action' );
            wp_schedule_event( time(), $gc_sync_interval, 'graphcomment_cron_task_sync_comments_action' );

            update_option( 'gc-msg', json_encode( array(
                'type'       => 'success',
                'content'    => __( 'Sync Activated', 'graphcomment-comment-system' ),
                'active_tab' => 'synchronization'
            ) ) );

            wp_redirect( admin_url( 'admin.php?page=graphcomment-settings' ) );
            exit;
        }
    }
}
