<?php

/**
 * Classe abstraite GcController
 *
 * Gère un onglet et fournit une structure de base pour les contrôleurs.
 */
if ( ! class_exists( 'GcController' ) ) {
    abstract class GcController {

        /**
         * Données du formulaire POST
         *
         * @var array
         */
        protected $post;

        /**
         * Constructeur de la classe
         *
         * @param array $post Les données du formulaire POST
         */
        public function __construct( $post ) {
            $this->post = $post;
        }

        /**
         * Méthode abstraite pour gérer le formulaire d'options.
         *
         * Les classes dérivées doivent implémenter cette méthode.
         */
        abstract public function handleOptionForm();

    }
}
